<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品对应的规格组和选择的规格信息
 * Class GoodsInSpecGroupTag
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsInSpecGroupTagRepository")
 * @ORM\Table(name="dbshop_goods_in_spec_group_tag")
 */
class GoodsInSpecGroupTag extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="in_group_tag_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $inGroupTagId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 规则组id
     * @ORM\Column(name="group_id", type="integer", length=11)
     */
    private $groupId;

    /**
     * 选择的id
     * @ORM\Column(name="selected_tag_id", type="string", length=1000)
     */
    private $selectedTagId;

    /**
     * 是否该组为图片组， 0 否，1 是
     * @ORM\Column(name="group_image", type="integer", length=1)
     */
    private $groupImage = 0;

    /**
     * @return mixed
     */
    public function getInGroupTagId()
    {
        return $this->inGroupTagId;
    }

    /**
     * @param mixed $inGroupTagId
     */
    public function setInGroupTagId($inGroupTagId): void
    {
        $this->inGroupTagId = $inGroupTagId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getGroupId()
    {
        return $this->groupId;
    }

    /**
     * @param mixed $groupId
     */
    public function setGroupId($groupId): void
    {
        $this->groupId = $groupId;
    }

    /**
     * @return mixed
     */
    public function getSelectedTagId()
    {
        return $this->selectedTagId;
    }

    /**
     * @param mixed $selectedTagId
     */
    public function setSelectedTagId($selectedTagId): void
    {
        $this->selectedTagId = $selectedTagId;
    }

    /**
     * @return int
     */
    public function getGroupImage(): int
    {
        return $this->groupImage;
    }

    /**
     * @param int $groupImage
     */
    public function setGroupImage(int $groupImage): void
    {
        $this->groupImage = $groupImage;
    }
}