<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 规格图片
 * Class GoodsInSpecImage
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsInSpecImageRepository")
 * @ORM\Table(name="dbshop_goods_in_spec_image")
 */
class GoodsInSpecImage extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="in_spec_image_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $inSpecImageId;

    /**
     * 标签id
     * @ORM\Column(name="tag_id", type="integer", length=11)
     */
    private $tagId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 图片id
     * @ORM\Column(name="goods_image_id", type="integer", length=11)
     */
    private $goodsImageId;

    /**
     * @return mixed
     */
    public function getInSpecImageId()
    {
        return $this->inSpecImageId;
    }

    /**
     * @param mixed $inSpecImageId
     */
    public function setInSpecImageId($inSpecImageId): void
    {
        $this->inSpecImageId = $inSpecImageId;
    }

    /**
     * @return mixed
     */
    public function getTagId()
    {
        return $this->tagId;
    }

    /**
     * @param mixed $tagId
     */
    public function setTagId($tagId): void
    {
        $this->tagId = $tagId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getGoodsImageId()
    {
        return $this->goodsImageId;
    }

    /**
     * @param mixed $goodsImageId
     */
    public function setGoodsImageId($goodsImageId): void
    {
        $this->goodsImageId = $goodsImageId;
    }
}