<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品对应的标签
 * Class GoodsInTag
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsInTagRepository")
 * @ORM\Table(name="dbshop_goods_in_tag")
 */
class GoodsInTag extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="in_tag_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $inTagId;

    /**
     * 标签id
     * @ORM\Column(name="tag_id", type="integer", length=11)
     */
    private $tagId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 标签商品排序
     * @ORM\Column(name="tag_goods_sort", type="integer", length=11)
     */
    private $tagGoodsSort;

    /**
     * @return mixed
     */
    public function getInTagId()
    {
        return $this->inTagId;
    }

    /**
     * @param mixed $inTagId
     */
    public function setInTagId($inTagId): void
    {
        $this->inTagId = $inTagId;
    }

    /**
     * @return mixed
     */
    public function getTagId()
    {
        return $this->tagId;
    }

    /**
     * @param mixed $tagId
     */
    public function setTagId($tagId): void
    {
        $this->tagId = $tagId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getTagGoodsSort()
    {
        return $this->tagGoodsSort;
    }

    /**
     * @param mixed $tagGoodsSort
     */
    public function setTagGoodsSort($tagGoodsSort): void
    {
        $this->tagGoodsSort = $tagGoodsSort;
    }
}