<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品批发价格
 * Class GoodsInWholesale
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsInWholesaleRepository")
 * @ORM\Table(name="dbshop_goods_in_wholesale")
 */
class GoodsInWholesale extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="in_wholesale_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $inWholesaleId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 批发区间-开始数量
     * @ORM\Column(name="wholesale_start_num", type="integer", length=11)
     */
    private $wholesaleStartNum;

    /**
     * 批发区间-结束数量
     * @ORM\Column(name="wholesale_end_num", type="integer", length=11)
     */
    private $wholesaleEndNum;

    /**
     * 批发单价
     * @ORM\Column(name="wholesale_price", type="decimal", scale=2)
     */
    private $wholesalePrice;

    /**
     * 对应的key值
     * @ORM\Column(name="wholesale_key", type="integer", length=2)
     */
    private $wholesaleKey;

    /**
     * @return mixed
     */
    public function getInWholesaleId()
    {
        return $this->inWholesaleId;
    }

    /**
     * @param mixed $inWholesaleId
     */
    public function setInWholesaleId($inWholesaleId): void
    {
        $this->inWholesaleId = $inWholesaleId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getWholesaleStartNum()
    {
        return $this->wholesaleStartNum;
    }

    /**
     * @param mixed $wholesaleStartNum
     */
    public function setWholesaleStartNum($wholesaleStartNum): void
    {
        $this->wholesaleStartNum = $wholesaleStartNum;
    }

    /**
     * @return mixed
     */
    public function getWholesaleEndNum()
    {
        return $this->wholesaleEndNum;
    }

    /**
     * @param mixed $wholesaleEndNum
     */
    public function setWholesaleEndNum($wholesaleEndNum): void
    {
        $this->wholesaleEndNum = $wholesaleEndNum;
    }

    /**
     * @return mixed
     */
    public function getWholesalePrice()
    {
        return $this->wholesalePrice;
    }

    /**
     * @param mixed $wholesalePrice
     */
    public function setWholesalePrice($wholesalePrice): void
    {
        $this->wholesalePrice = $wholesalePrice;
    }

    /**
     * @return mixed
     */
    public function getWholesaleKey()
    {
        return $this->wholesaleKey;
    }

    /**
     * @param mixed $wholesaleKey
     */
    public function setWholesaleKey($wholesaleKey): void
    {
        $this->wholesaleKey = $wholesaleKey;
    }
}