<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品销量
 * Class GoodsSalesRecord
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsSalesRecordRepository")
 * @ORM\Table(name="dbshop_goods_sales_record")
 */
class GoodsSalesRecord extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="sales_record_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $salesRecordId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 销售数量
     * @ORM\Column(name="goods_sales_num", type="integer", length=11)
     */
    private $goodsSalesNum = 0;

    /**
     * @return mixed
     */
    public function getSalesRecordId()
    {
        return $this->salesRecordId;
    }

    /**
     * @param mixed $salesRecordId
     */
    public function setSalesRecordId($salesRecordId): void
    {
        $this->salesRecordId = $salesRecordId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return int
     */
    public function getGoodsSalesNum(): int
    {
        return $this->goodsSalesNum;
    }

    /**
     * @param int $goodsSalesNum
     */
    public function setGoodsSalesNum(int $goodsSalesNum): void
    {
        $this->goodsSalesNum = $goodsSalesNum;
    }
}