<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 特定商品标签
 * Class GoodsSpecTag
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsSpecTagRepository")
 * @ORM\Table(name="dbshop_goods_spec_tag")
 */
class GoodsSpecTag extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="spec_tag_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $specTagId;

    /**
     * 标签名称
     * @ORM\Column(name="spec_tag_name", type="string", length=100)
     */
    private $specTagName;

    /**
     * 标签标记
     * @ORM\Column(name="spec_tag_code", type="string", length=50)
     */
    private $specTagCode;

    /**
     * 排序
     * @ORM\Column(name="spec_tag_sort", type="integer", length=11)
     */
    private $specTagSort;

    /**
     * 模板标记
     * @ORM\Column(name="template_code", type="string", length=50)
     */
    private $templateCode;

    /**
     * @return mixed
     */
    public function getSpecTagId()
    {
        return $this->specTagId;
    }

    /**
     * @param mixed $specTagId
     */
    public function setSpecTagId($specTagId): void
    {
        $this->specTagId = $specTagId;
    }

    /**
     * @return mixed
     */
    public function getSpecTagName()
    {
        return $this->specTagName;
    }

    /**
     * @param mixed $specTagName
     */
    public function setSpecTagName($specTagName): void
    {
        $this->specTagName = $specTagName;
    }

    /**
     * @return mixed
     */
    public function getSpecTagCode()
    {
        return $this->specTagCode;
    }

    /**
     * @param mixed $specTagCode
     */
    public function setSpecTagCode($specTagCode): void
    {
        $this->specTagCode = $specTagCode;
    }

    /**
     * @return mixed
     */
    public function getSpecTagSort()
    {
        return $this->specTagSort;
    }

    /**
     * @param mixed $specTagSort
     */
    public function setSpecTagSort($specTagSort): void
    {
        $this->specTagSort = $specTagSort;
    }

    /**
     * @return mixed
     */
    public function getTemplateCode()
    {
        return $this->templateCode;
    }

    /**
     * @param mixed $templateCode
     */
    public function setTemplateCode($templateCode): void
    {
        $this->templateCode = $templateCode;
    }
}