<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 特定标签商品
 * Class GoodsSpecTagGoods
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsSpecTagGoodsRepository")
 * @ORM\Table(name="dbshop_goods_spec_tag_goods")
 */
class GoodsSpecTagGoods extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="spec_tag_goods_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $specTagGoodsId;

    /**
     * 特定标签id
     * @ORM\Column(name="spec_tag_id", type="integer", length=11)
     */
    private $specTagId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 特定标签商品排序
     * @ORM\Column(name="spec_tag_goods_sort", type="integer", length=11)
     */
    private $specTagGoodsSort;

    /**
     * 标签标记
     * @ORM\Column(name="spec_tag_code", type="string", length=50)
     */
    private $specTagCode;

    /**
     * 模板名称标记
     * @ORM\Column(name="template_code", type="string", length=50)
     */
    private $templateCode;

    /**
     * @return mixed
     */
    public function getSpecTagGoodsId()
    {
        return $this->specTagGoodsId;
    }

    /**
     * @param mixed $specTagGoodsId
     */
    public function setSpecTagGoodsId($specTagGoodsId): void
    {
        $this->specTagGoodsId = $specTagGoodsId;
    }

    /**
     * @return mixed
     */
    public function getSpecTagId()
    {
        return $this->specTagId;
    }

    /**
     * @param mixed $specTagId
     */
    public function setSpecTagId($specTagId): void
    {
        $this->specTagId = $specTagId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getSpecTagGoodsSort()
    {
        return $this->specTagGoodsSort;
    }

    /**
     * @param mixed $specTagGoodsSort
     */
    public function setSpecTagGoodsSort($specTagGoodsSort): void
    {
        $this->specTagGoodsSort = $specTagGoodsSort;
    }

    /**
     * @return mixed
     */
    public function getSpecTagCode()
    {
        return $this->specTagCode;
    }

    /**
     * @param mixed $specTagCode
     */
    public function setSpecTagCode($specTagCode): void
    {
        $this->specTagCode = $specTagCode;
    }

    /**
     * @return mixed
     */
    public function getTemplateCode()
    {
        return $this->templateCode;
    }

    /**
     * @param mixed $templateCode
     */
    public function setTemplateCode($templateCode): void
    {
        $this->templateCode = $templateCode;
    }
}