<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品库存与购买
 * Class GoodsStock
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsStockRepository")
 * @ORM\Table(name="dbshop_goods_stock")
 */
class GoodsStock extends BaseEntity
{
    /**
     * 库存id（自增id）
     * @ORM\Id()
     * @ORM\Column(name="stock_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $stockId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 库存数量（当有规格商品时，库存以规格商品为准）
     * @ORM\Column(name="stock_num", type="integer", length=11)
     */
    private $stockNum;

    /**
     * 库存显示文字（有货时的显示）
     * @ORM\Column(name="stock_show", type="string", length=30)
     */
    private $stockShow;

    /**
     * 库存显示状态， 1 启用（启用后显示上面stock_show的文字）， 0 关闭
     * @ORM\Column(name="stock_show_state", type="integer", length=1)
     */
    private $stockShowState;

    /**
     * 商品缺货数量
     * @ORM\Column(name="stock_out_set_num", type="integer", length=11)
     */
    private $stockOutSetNum;

    /**
     * 库存缺货显示文字
     * @ORM\Column(name="stock_out_show", type="string", length=30)
     */
    private $stockOutShow;

    /**
     * 购物车最少数量， 0 不限制
     * @ORM\Column(name="cart_buy_min_num", type="integer", length=11)
     */
    private $cartBuyMinNum;

    /**
     * 购物车最多数量， 0 不限制
     * @ORM\Column(name="cart_buy_max_num", type="integer", length=11)
     */
    private $cartBuyMaxNum;

    /**
     * 每人最多买的次数， 0 不限制
     * @ORM\Column(name="person_buy_max", type="integer", length=11)
     */
    private $personBuyMax;

    /**
     * @return mixed
     */
    public function getStockId()
    {
        return $this->stockId;
    }

    /**
     * @param mixed $stockId
     */
    public function setStockId($stockId): void
    {
        $this->stockId = $stockId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getStockNum()
    {
        return $this->stockNum;
    }

    /**
     * @param mixed $stockNum
     */
    public function setStockNum($stockNum): void
    {
        $this->stockNum = $stockNum;
    }

    /**
     * @return mixed
     */
    public function getStockShow()
    {
        return $this->stockShow;
    }

    /**
     * @param mixed $stockShow
     */
    public function setStockShow($stockShow): void
    {
        $this->stockShow = $stockShow;
    }

    /**
     * @return mixed
     */
    public function getStockShowState()
    {
        return $this->stockShowState;
    }

    /**
     * @param mixed $stockShowState
     */
    public function setStockShowState($stockShowState): void
    {
        $this->stockShowState = $stockShowState;
    }

    /**
     * @return mixed
     */
    public function getStockOutSetNum()
    {
        return $this->stockOutSetNum;
    }

    /**
     * @param mixed $stockOutSetNum
     */
    public function setStockOutSetNum($stockOutSetNum): void
    {
        $this->stockOutSetNum = $stockOutSetNum;
    }

    /**
     * @return mixed
     */
    public function getStockOutShow()
    {
        return $this->stockOutShow;
    }

    /**
     * @param mixed $stockOutShow
     */
    public function setStockOutShow($stockOutShow): void
    {
        $this->stockOutShow = $stockOutShow;
    }

    /**
     * @return mixed
     */
    public function getCartBuyMinNum()
    {
        return $this->cartBuyMinNum;
    }

    /**
     * @param mixed $cartBuyMinNum
     */
    public function setCartBuyMinNum($cartBuyMinNum): void
    {
        $this->cartBuyMinNum = $cartBuyMinNum;
    }

    /**
     * @return mixed
     */
    public function getCartBuyMaxNum()
    {
        return $this->cartBuyMaxNum;
    }

    /**
     * @param mixed $cartBuyMaxNum
     */
    public function setCartBuyMaxNum($cartBuyMaxNum): void
    {
        $this->cartBuyMaxNum = $cartBuyMaxNum;
    }

    /**
     * @return mixed
     */
    public function getPersonBuyMax()
    {
        return $this->personBuyMax;
    }

    /**
     * @param mixed $personBuyMax
     */
    public function setPersonBuyMax($personBuyMax): void
    {
        $this->personBuyMax = $personBuyMax;
    }
}