<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品标签
 * Class GoodsTag
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsTagRepository")
 * @ORM\Table(name="dbshop_goods_tag")
 */
class GoodsTag extends BaseEntity
{
    /**
     * 标签id
     * @ORM\Id()
     * @ORM\Column(name="tag_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $tagId;

    /**
     * 标签名称
     * @ORM\Column(name="tag_name", type="string", length=100)
     */
    private $tagName;

    /**
     * 标签组id
     * @ORM\Column(name="tag_group_id", type="integer", length=11)
     */
    private $tagGroupId;

    /**
     * 标签扩展内容，如 颜色
     * @ORM\Column(name="tag_str", type="string", length=50)
     */
    private $tagStr;

    /**
     * 标签排序
     * @ORM\Column(name="tag_sort", type="integer", length=11)
     */
    private $tagSort;

    /**
     * 标签组
     * @ORM\OneToOne(targetEntity="Goods\Entity\GoodsTagGroup")
     * @ORM\JoinColumn(name="tag_group_id", referencedColumnName="tag_group_id")
     */
    private $oneTagGroup;

    /**
     * @return mixed
     */
    public function getTagId()
    {
        return $this->tagId;
    }

    /**
     * @param mixed $tagId
     */
    public function setTagId($tagId): void
    {
        $this->tagId = $tagId;
    }

    /**
     * @return mixed
     */
    public function getTagName()
    {
        return $this->tagName;
    }

    /**
     * @param mixed $tagName
     */
    public function setTagName($tagName): void
    {
        $this->tagName = $tagName;
    }

    /**
     * @return mixed
     */
    public function getTagGroupId()
    {
        return $this->tagGroupId;
    }

    /**
     * @param mixed $tagGroupId
     */
    public function setTagGroupId($tagGroupId): void
    {
        $this->tagGroupId = $tagGroupId;
    }

    /**
     * @return mixed
     */
    public function getTagStr()
    {
        return $this->tagStr;
    }

    /**
     * @param mixed $tagStr
     */
    public function setTagStr($tagStr): void
    {
        $this->tagStr = $tagStr;
    }

    /**
     * @return mixed
     */
    public function getTagSort()
    {
        return $this->tagSort;
    }

    /**
     * @param mixed $tagSort
     */
    public function setTagSort($tagSort): void
    {
        $this->tagSort = $tagSort;
    }

    /**
     * @return mixed
     */
    public function getOneTagGroup()
    {
        return $this->oneTagGroup;
    }

    /**
     * @param mixed $oneTagGroup
     */
    public function setOneTagGroup($oneTagGroup): void
    {
        $this->oneTagGroup = $oneTagGroup;
    }
}