<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 商品标签组
 * Class GoodsTagGroup
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsTagGroupRepository")
 * @ORM\Table(name="dbshop_goods_tag_group")
 */
class GoodsTagGroup extends BaseEntity
{
    /**
     * 标签组id
     * @ORM\Id()
     * @ORM\Column(name="tag_group_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $tagGroupId;

    /**
     * 标签组名称
     * @ORM\Column(name="tag_group_name", type="string", length=250)
     */
    private $tagGroupName;

    /**
     * 标签组标记
     * @ORM\Column(name="tag_group_mark", type="string", length=50)
     */
    private $tagGroupMark;

    /**
     * 是否用于规格，1 启用，0 禁用
     * @ORM\Column(name="is_goods_spec", type="integer", length=1)
     */
    private $isGoodsSpec;

    /**
     * 排序，默认 255
     * @ORM\Column(name="tag_group_sort", type="integer", length=11)
     */
    private $tagGroupSort;

    /**
     * @return mixed
     */
    public function getTagGroupId()
    {
        return $this->tagGroupId;
    }

    /**
     * @param mixed $tagGroupId
     */
    public function setTagGroupId($tagGroupId): void
    {
        $this->tagGroupId = $tagGroupId;
    }

    /**
     * @return mixed
     */
    public function getTagGroupName()
    {
        return $this->tagGroupName;
    }

    /**
     * @param mixed $tagGroupName
     */
    public function setTagGroupName($tagGroupName): void
    {
        $this->tagGroupName = $tagGroupName;
    }

    /**
     * @return mixed
     */
    public function getTagGroupMark()
    {
        return $this->tagGroupMark;
    }

    /**
     * @param mixed $tagGroupMark
     */
    public function setTagGroupMark($tagGroupMark): void
    {
        $this->tagGroupMark = $tagGroupMark;
    }

    /**
     * @return mixed
     */
    public function getIsGoodsSpec()
    {
        return $this->isGoodsSpec;
    }

    /**
     * @param mixed $isGoodsSpec
     */
    public function setIsGoodsSpec($isGoodsSpec): void
    {
        $this->isGoodsSpec = $isGoodsSpec;
    }

    /**
     * @return mixed
     */
    public function getTagGroupSort()
    {
        return $this->tagGroupSort;
    }

    /**
     * @param mixed $tagGroupSort
     */
    public function setTagGroupSort($tagGroupSort): void
    {
        $this->tagGroupSort = $tagGroupSort;
    }
}