<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;
use Laminas\Form\Annotation\ComposedObject;

/**
 * 虚拟商品账号信息
 * Class GoodsVirtual
 * @package Goods\Entity
 * @ORM\Entity(repositoryClass="Goods\Repository\GoodsVirtualRepository")
 * @ORM\Table(name="dbshop_goods_virtual")
 */
class GoodsVirtual extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="virtual_goods_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $virtualGoodsId;

    /**
     * 账号
     * @ORM\Column(name="virtual_goods_account", type="string", length=150)
     */
    private $virtualGoodsAccount;

    /**
     * 账号类型，1 手动添加，2 自动生成，3 自动重复
     * @ORM\Column(name="virtual_goods_account_type", type="integer", length=1)
     */
    private $virtualGoodsAccountType;

    /**
     * 密码
     * @ORM\Column(name="virtual_goods_password", type="string", length=150)
     */
    private $virtualGoodsPassword;

    /**
     * 密码类型，1 手动添加，2 自动生成，3 自动重复
     * @ORM\Column(name="virtual_goods_password_type", type="integer", length=1)
     */
    private $virtualGoodsPasswordType;

    /**
     * 过期时间
     * @ORM\Column(name="virtual_goods_end_time", type="integer", length=10)
     */
    private $virtualGoodsEndTime;

    /**
     * 虚拟商品状态，1 未交易，2 已交易，3 已过期
     * @ORM\Column(name="virtual_goods_state", type="integer", length=1)
     */
    private $virtualGoodsState = 1;

    /**
     * 订单编号
     * @ORM\Column(name="order_sn", type="string", length=50)
     */
    private $orderSn;

    /**
     * 订单id
     * @ORM\Column(name="order_id", type="integer", length=11)
     */
    private $orderId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId = 0;

    /**
     * 会员名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * @return mixed
     */
    public function getVirtualGoodsId()
    {
        return $this->virtualGoodsId;
    }

    /**
     * @param mixed $virtualGoodsId
     */
    public function setVirtualGoodsId($virtualGoodsId): void
    {
        $this->virtualGoodsId = $virtualGoodsId;
    }

    /**
     * @return mixed
     */
    public function getVirtualGoodsAccount()
    {
        return $this->virtualGoodsAccount;
    }

    /**
     * @param mixed $virtualGoodsAccount
     */
    public function setVirtualGoodsAccount($virtualGoodsAccount): void
    {
        $this->virtualGoodsAccount = $virtualGoodsAccount;
    }

    /**
     * @return mixed
     */
    public function getVirtualGoodsAccountType()
    {
        return $this->virtualGoodsAccountType;
    }

    /**
     * @param mixed $virtualGoodsAccountType
     */
    public function setVirtualGoodsAccountType($virtualGoodsAccountType): void
    {
        $this->virtualGoodsAccountType = $virtualGoodsAccountType;
    }

    /**
     * @return mixed
     */
    public function getVirtualGoodsPassword()
    {
        return $this->virtualGoodsPassword;
    }

    /**
     * @param mixed $virtualGoodsPassword
     */
    public function setVirtualGoodsPassword($virtualGoodsPassword): void
    {
        $this->virtualGoodsPassword = $virtualGoodsPassword;
    }

    /**
     * @return mixed
     */
    public function getVirtualGoodsPasswordType()
    {
        return $this->virtualGoodsPasswordType;
    }

    /**
     * @param mixed $virtualGoodsPasswordType
     */
    public function setVirtualGoodsPasswordType($virtualGoodsPasswordType): void
    {
        $this->virtualGoodsPasswordType = $virtualGoodsPasswordType;
    }

    /**
     * @return mixed
     */
    public function getVirtualGoodsEndTime()
    {
        return $this->virtualGoodsEndTime;
    }

    /**
     * @param mixed $virtualGoodsEndTime
     */
    public function setVirtualGoodsEndTime($virtualGoodsEndTime): void
    {
        $this->virtualGoodsEndTime = $virtualGoodsEndTime;
    }

    /**
     * @return int
     */
    public function getVirtualGoodsState(): int
    {
        return $this->virtualGoodsState;
    }

    /**
     * @param int $virtualGoodsState
     */
    public function setVirtualGoodsState(int $virtualGoodsState): void
    {
        $this->virtualGoodsState = $virtualGoodsState;
    }

    /**
     * @return mixed
     */
    public function getOrderSn()
    {
        return $this->orderSn;
    }

    /**
     * @param mixed $orderSn
     */
    public function setOrderSn($orderSn): void
    {
        $this->orderSn = $orderSn;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param mixed $orderId
     */
    public function setOrderId($orderId): void
    {
        $this->orderId = $orderId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }
}