<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Form;

use Laminas\Form\Form;

class GoodsAttributeValueFrom extends Form
{
    private $formType = 'add';

    public function __construct($formType = 'add', $name = 'goods-attribute-value-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->formType = $formType;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        if($this->formType == 'add') {
            $this->add([
                'type'  => 'textarea',
                'name'  => 'valueName',
                'attributes'    => [
                    'id'            => 'valueName',
                    'class'         => 'form-control',
                    'rows'          => 5
                ]
            ]);
        } else {
            $this->add([
                'type'  => 'text',
                'name'  => 'valueName',
                'attributes'    => [
                    'id'            => 'valueName',
                    'class'         => 'form-control'
                ]
            ]);
        }

        $this->add([
            'type'  => 'number',
            'name'  => 'valueSort',
            'attributes'    => [
                'id'            => 'valueSort',
                'class'         => 'form-control',
                'value'         => 255
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'valueName',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 100
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'valueSort',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);
    }
}