<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Form;

use Admin\Data\Common;
use Admin\Data\Config;
use Admin\Filter\ImageThumb;
use Admin\Filter\OldImage;
use Laminas\Form\Form;

class GoodsBrandForm extends Form
{
    private $brand;

    public function __construct($brand = null, $name = 'goods-brand-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('enctype', 'multipart/form-data');
        $this->setAttribute('class', 'form-horizontal');

        $this->brand = $brand;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'brandName',
            'attributes'    => [
                'id'            => 'brandName',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'brandLogo',
            'attributes'    => [
                'id'            => 'brandLogo',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'brandSort',
            'attributes'    => [
                'id'            => 'brandSort',
                'class'         => 'form-control',
                'value'         => 255
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'inClassId'
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'brandInfo'
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'brandNameExtend',
            'attributes'    => [
                'id'            => 'brandNameExtend',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'brandKeywords',
            'attributes'    => [
                'id'            => 'brandKeywords',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'brandDescription',
            'attributes'    => [
                'id'            => 'brandDescription',
                'class'         => 'form-control',
                'rows'          => 4
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'brandName',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 150
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'brandLogo',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::GOODS_BRAND_IMAGE_PATH,
                        'useUploadName'=>true,
                        'useUploadExtension'=>true,
                        'overwrite'=>true
                    ]
                ],
                [
                    'name' => ImageThumb::class,
                    'options' => [
                        'width' => Common::configValue('brand_logo_width'),
                        'height'=> Common::configValue('brand_logo_height'),
                        'mode'  => Common::configValue('brand_logo_crop')
                    ]
                ],
                [
                    'name' => OldImage::class,
                    'options' => [
                        'oldImage' => $this->brand ? $this->brand->getBrandLogo() : ''
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'brandSort',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'inClassId',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'brandInfo',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'brandNameExtend',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 255
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'brandKeywords',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 255
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'brandDescription',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 1000
                    ]
                ]
            ]
        ]);
    }
}