<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Form;

use Admin\Data\Common;
use Admin\Data\Config;
use Admin\Filter\ImageThumb;
use Admin\Filter\OldImage;
use Goods\Validator\GoodsClassValidator;
use Laminas\Form\Form;

class GoodsClassForm extends Form
{
    private $entityManager;
    private $goodsClass;

    public function __construct($entityManager = null, $goodsClass = null, $name = 'goods-class-form', array $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('enctype', 'multipart/form-data');
        $this->setAttribute('class', 'form-horizontal');

        $this->entityManager= $entityManager;
        $this->goodsClass   = $goodsClass;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'select',
            'name'  => 'classTopId',
            'attributes'    => [
                'id'            => 'classTopId',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'className',
            'attributes'    => [
                'id'            => 'className',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'classInfo',
            'attributes'    => [
                'id'            => 'classInfo',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'classImage',
            'attributes'    => [
                'id'            => 'classImage',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'classTagGroup',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'classState',
            'attributes'    => [
                'id'            => 'classState',
                'value'         => 1
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'classExtend',
            'attributes'    => [
                'id'            => 'classExtend',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'classKeywords',
            'attributes'    => [
                'id'            => 'classKeywords',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'classDescription',
            'attributes'    => [
                'id'            => 'classDescription',
                'class'         => 'form-control',
                'rows'          => 4
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'classSort',
            'attributes'    => [
                'id'            => 'classSort',
                'class'         => 'form-control',
                'value'         => 255
            ]
        ]);

    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'classTopId',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => GoodsClassValidator::class,
                    'options'    => [
                        'entityManager' => $this->entityManager,
                        'goodsClass'    => $this->goodsClass
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'className',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 150
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'classInfo',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 3000
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'classImage',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::GOODS_CLASS_IMAGE_PATH,
                        'useUploadName'=>true,
                        'useUploadExtension'=>true,
                        'overwrite'=>true
                    ]
                ],
                [
                    'name' => ImageThumb::class,
                    'options' => [
                        'width' => Common::configValue('class_image_width'),
                        'height'=> Common::configValue('class_image_height'),
                        'mode'  => Common::configValue('class_image_crop')
                    ]
                ],
                [
                    'name' => OldImage::class,
                    'options' => [
                        'oldImage' => $this->goodsClass ? $this->goodsClass->getClassImage() : ''
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'classState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'classExtend',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 255
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'classKeywords',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 255
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'classDescription',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 1000
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'classTagGroup',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'classSort',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);
    }
}