<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Form;

use Laminas\Form\Form;

class GoodsCommonContentForm extends Form
{
    public function __construct($name = 'goods-common-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'contentTitle',
            'attributes'    => [
                'id'            => 'contentTitle',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'contentBody',
            'attributes'    => [
                'id'            => 'contentBody',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'contentSort',
            'attributes'    => [
                'id'    => 'contentSort',
                'class' => 'form-control',
                'value' => 255,
                'min'   => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'contentState',
            'attributes'    => [
                'id'            => 'contentState',
                'value'         => 1
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'classId'
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'contentTitle',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'classId',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'contentBody',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'contentSort',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'contentState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);
    }
}