<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Form;

use Laminas\Form\Form;
use Laminas\Validator\GreaterThan;

/**
 * 商品基本信息（商品添加与编辑）
 * Class GoodsForm
 * @package Goods\Form
 */
class GoodsForm extends Form
{
    public $inputFilter;

    public function __construct($name = 'goods-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');
        $this->setAttribute('onsubmit', 'return goodsFormSubmit();');

        $this->addElements();
        $this->inputFilter = $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'goodsItem',
            'attributes'    => [
                'id'            => 'goodsItem',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'brandId',
            'attributes'    => [
                'id'            => 'brandId',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'goodsName',
            'attributes'    => [
                'id'            => 'goodsName',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'goodsExtendName',
            'attributes'    => [
                'id'            => 'goodsExtendName',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'goodsWeight',
            'attributes'    => [
                'id'            => 'goodsWeight',
                'class'         => 'form-control',
                'value'     => 0
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'goodsWeightConversion',
            'attributes'    => [
                'id'            => 'goodsWeightConversion',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'goodsMarketPrice',
            'attributes'    => [
                'id'            => 'goodsMarketPrice',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'goodsPrice',
            'attributes'    => [
                'id'            => 'goodsPrice',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'goodsBody',
            'attributes'    => [
                'id'            => 'goodsBody',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'virtualSales',
            'attributes'    => [
                'id'            => 'virtualSales',
                'class'         => 'form-control',
                'min'       => 0,
                'value'     => 0
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'goodsState',
            'attributes'    => [
                'id'            => 'goodsState',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'goodsType',
            'attributes'    => [
                'id'            => 'goodsType',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'attributeGroupId',
            'attributes'    => [
                'id'            => 'attributeGroupId',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'goodsIntegralBuy',
            'options' => [
                'checked_value' => 1,
                'unchecked_value' => 0,
            ],
            'attributes'    => [
                'id'            => 'goodsIntegralBuy'
            ]
        ]);

        /*=========================图片=========================*/
        $this->add([
            'type'  => 'number',
            'name'  => 'defaultImage',
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'goodsImageId'
        ]);
        /*=========================分类=========================*/
        $this->add([
            'type'  => 'number',
            'name'  => 'classId',
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'inClassId'
        ]);

        /*=========================库存=========================*/
        $this->add([
            'type'  => 'number',
            'name'  => 'stockNum',
            'attributes'    => [
                'id'            => 'stockNum',
                'class'         => 'form-control',
                'min'       => 1,
                'value'     => 10
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'stockShow',
            'attributes'    => [
                'id'            => 'stockShow',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'stockShowState',
            'options' => [
                'checked_value' => 1,
                'unchecked_value' => 0,
            ],
            'attributes'    => [
                'id'            => 'stockShowState'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'stockOutSetNum',
            'attributes'    => [
                'id'            => 'stockOutSetNum',
                'class'         => 'form-control',
                'min'       => 0,
                'value'     => 0
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'stockOutShow',
            'attributes'    => [
                'id'            => 'stockOutShow',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'cartBuyMinNum',
            'attributes'    => [
                'id'            => 'cartBuyMinNum',
                'class'         => 'form-control',
                'min'       => 0,
                'value'     => 0
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'cartBuyMaxNum',
            'attributes'    => [
                'id'            => 'cartBuyMaxNum',
                'class'         => 'form-control',
                'min'       => 0,
                'value'     => 0
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'personBuyMax',
            'attributes'    => [
                'id'            => 'personBuyMax',
                'class'         => 'form-control',
                'min'       => 0,
                'value'     => 0
            ]
        ]);

        /*=========================优惠=========================*/
        $this->add([
            'type'  => 'text',
            'name'  => 'discountPrice',
            'attributes'    => [
                'id'            => 'discountPrice',
                'class'         => 'form-control',
                'value'     => '0.00'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'discountStartTime',
            'attributes'    => [
                'id'            => 'discountStartTime',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'discountEndTime',
            'attributes'    => [
                'id'            => 'discountEndTime',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'discountUserGroupType',
            'attributes'    => [
                'id'            => 'discountUserGroupType',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'discountUserGroup',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ],
            'attributes'    => [
                'id'            => 'discountUserGroup',
                'class'         => 'form-control'
            ]
        ]);

        /*=========================批发=========================*/
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'wholesaleState',
            'options' => [
                'checked_value' => 1,
                'unchecked_value' => 0,
            ],
            'attributes'    => [
                'id'            => 'wholesaleState'
            ]
        ]);

        /*=========================SEO优化=========================*/
        $this->add([
            'type'  => 'text',
            'name'  => 'goodsKeywords',
            'attributes'    => [
                'id'            => 'goodsKeywords',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'goodsDescription',
            'attributes'    => [
                'id'    => 'goodsDescription',
                'class' => 'form-control',
                'rows'  => 4
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'goodsItem',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 50
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'brandId',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsName',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsExtendName',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 255
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsWeight',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsWeightConversion',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsMarketPrice',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToFloat']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsPrice',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToFloat']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsBody',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'virtualSales',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsState',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsType',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'attributeGroupId',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsIntegralBuy',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        /*=========================图片=========================*/
        $inputFilter->add([
            'name'      => 'defaultImage',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);
        $inputFilter->add([
            'name'      => 'goodsImageId',
            'required'  => false
        ]);
        /*=========================分类=========================*/
        $inputFilter->add([
            'name'      => 'classId',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ],
        ]);
        $inputFilter->add([
            'name'      => 'inClassId',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        /*=========================库存=========================*/
        $inputFilter->add([
            'name'      => 'stockNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'stockShow',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 30
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'stockShowState',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'stockOutSetNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'stockOutShow',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 30
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'cartBuyMinNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'cartBuyMaxNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'personBuyMax',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        /*=========================优惠=========================*/
        $inputFilter->add([
            'name'      => 'discountPrice',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToFloat']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'discountStartTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'discountEndTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'discountUserGroupType',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => ['allUser', 'userGroup']
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'discountUserGroup',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        /*=========================批发=========================*/
        $inputFilter->add([
            'name'      => 'wholesaleState',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        /*=========================SEO优化=========================*/
        $inputFilter->add([
            'name'      => 'goodsKeywords',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 255
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsDescription',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 1000
                    ]
                ]
            ]
        ]);

        return $inputFilter;
    }
}