<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Form;

use Admin\Data\Common;
use Admin\Data\Config;
use Admin\Filter\ImageThumb;
use Admin\Filter\ImageWatermark;
use Laminas\Form\Form;

class GoodsImageForm extends Form
{
    public function __construct($name = 'goods-image-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('enctype', 'multipart/form-data');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'goodsId'
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'goodsImage'
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'imageSlide'
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'imageCode'
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'imageSort'
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'goodsId',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'goodsImage',
            'required'  => true,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::GOODS_IMAGE_PATH,
                        'useUploadName' => true,
                        'useUploadExtension' => true,
                        'overwrite' => true,
                        'randomize' => Common::configValue('goods_image_name_type') == 'random' ? true : false
                    ]
                ],
                [
                    'name' => ImageWatermark::class
                ],
                [
                    'name' => ImageThumb::class,
                    'options' => [
                        'width' => Common::configValue('goods_thumb_width'),
                        'height'=> Common::configValue('goods_thumb_height'),
                        'mode'  => Common::configValue('goods_image_crop'),
                        'rename'=> true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'imageSlide',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'imageCode',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'imageSort',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);
    }
}