<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Form;

use Laminas\Form\Form;

class GoodsTagForm extends Form
{
    private $formType;

    public function __construct($formType = 'add', $name = 'goods-tag-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->formType = $formType;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'select',
            'name'  => 'tagGroupId',
            'attributes'    => [
                'id'            => 'tagGroupId',
                'class'         => 'form-control'
            ]
        ]);

        if($this->formType == 'add') {
            $this->add([
                'type'  => 'textarea',
                'name'  => 'tagName',
                'attributes'    => [
                    'id'            => 'tagName',
                    'class'         => 'form-control',
                    'rows'          => 4
                ]
            ]);
        } else {
            $this->add([
                'type'  => 'text',
                'name'  => 'tagName',
                'attributes'    => [
                    'id'            => 'tagName',
                    'class'         => 'form-control'
                ]
            ]);
        }

        $this->add([
            'type'  => 'number',
            'name'  => 'tagSort',
            'attributes'    => [
                'id'            => 'tagSort',
                'class'         => 'form-control',
                'value'         => 255
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'tagStr',
            'attributes'    => [
                'id'            => 'tagStr',
                'class'         => 'form-control iColorPicker',
                'style'         => 'width:60%;display:inline;'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'tagGroupId',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'tagName',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'tagSort',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);
    }
}