<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Form;

use Laminas\Form\Form;

class GoodsVirtualForm extends Form
{
    public function __construct($name = 'goods-virtual-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'hidden',
            'name'  => 'virtualGoodsId',
            'attributes'    => [
                'id'            => 'virtualGoodsId'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'virtualGoodsAccount',
            'attributes'    => [
                'id'            => 'virtualGoodsAccount',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'virtualGoodsAccountType',
            'attributes'    => [
                'id'            => 'virtualGoodsAccountType',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'virtualGoodsPassword',
            'attributes'    => [
                'id'            => 'virtualGoodsPassword',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'virtualGoodsPasswordType',
            'attributes'    => [
                'id'            => 'virtualGoodsPasswordType',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'virtualGoodsEndTime',
            'attributes'    => [
                'id'            => 'virtualGoodsEndTime',
                'class'         => 'form-control'
            ]
        ]);
    }


    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'virtualGoodsId',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'virtualGoodsAccount',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 150
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'virtualGoodsPassword',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 150
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'virtualGoodsEndTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}