<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Form;

use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class SearchGoodsTagForm extends Form
{
    private $translator;

    public function __construct($name = 'search-goods-tag-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'get');
        $this->setAttribute('class', 'form-horizontal');

        $this->translator = new Translator();

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'tag_name',
            'attributes'    => [
                'id'            => 'tag_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('标签名称')
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'tag_group_id',
            'attributes'    => [
                'id'            => 'tag_group_id',
                'class'         => 'form-control input-sm'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'tag_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'tag_group_id',
            'required'  => false
        ]);
    }
}