<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Goods\Entity\GoodsAttribute;

class GoodsAttributeRepository extends EntityRepository
{
    /**
     * 商品属性列表
     * @return mixed
     */
    public function findAllAttribute()
    {
        return $this->getEntityManager()->createQueryBuilder()
            ->select('a', 'g')
            ->from(GoodsAttribute::class, 'a')
            ->leftJoin('a.oneAttributeGroup', 'g')
            ->orderBy('a.attributeSort', 'ASC')
            ->addOrderBy('a.attributeId', 'ASC')
            ->getQuery()->getResult();
    }
}