<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Goods\Entity\GoodsBrand;
use Goods\Entity\GoodsBrandInClass;

class GoodsBrandInClassRepository extends EntityRepository
{
    /**
     * 获取分类对应的品牌
     * @param $classId
     * @return mixed
     */
    public function findBrandInClass($classId)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('i', 'b.brandName', 'b.brandLogo')
            ->from(GoodsBrandInClass::class, 'i')
            ->innerJoin(GoodsBrand::class, 'b', Join::WITH, 'i.brandId = b.brandId')
            ->where('i.classId = :classId')->setParameter('classId', $classId)
            ->orderBy('b.brandSort', 'ASC');

        return $query->getQuery()->getResult();
    }
}