<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Goods\Entity\Goods;
use Goods\Entity\GoodsBrand;

class GoodsBrandRepository extends EntityRepository
{
    /**
     * 品牌列表，主要用于后台
     * @return array
     */
    public function findAllBrand()
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('b')
            ->addSelect('(SELECT COUNT(g.goodsId) FROM '.Goods::class.' AS g WHERE g.brandId = b.brandId) AS goodsNum')
            ->from(GoodsBrand::class, 'b')
            ->orderBy('b.brandSort', 'ASC');

        return $query->getQuery()->getResult();
    }
}