<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Goods\Entity\GoodsCommonContent;

class GoodsCommonContentRepository extends EntityRepository
{
    /**
     * 根据商品分类id获取信息，用于前台
     * @param $classId
     * @return int|mixed|string
     */
    public function findGoodsCommonContent($classId)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('c')
            ->from(GoodsCommonContent::class, 'c')
            ->where($query->expr()->like('c.classIdStr', "'%,".$classId.",%'"))
            ->andWhere('c.contentState = 1')
            ->orderBy('c.contentSort', 'ASC');

        return $query->getQuery()->getResult();
    }
}