<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Goods\Entity\Goods;
use Goods\Entity\GoodsConsultation;
use Goods\Repository\QuerySearch\GoodsConsultSearch;
use User\Entity\User;

class GoodsConsultationRepository extends EntityRepository
{
    /**
     * 商品咨询列表
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findGoodsConsultList(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('c', 'g.goodsName')
            ->from(GoodsConsultation::class, 'c')
            ->leftJoin(Goods::class, 'g', Join::WITH, 'c.goodsId = g.goodsId')
            ->orderBy('c.consultId', 'DESC');

        $query = GoodsConsultSearch::querySearch($search, $query);

        return $query->getQuery();
    }

    /*==============================================下面为前台调用==============================================*/

    /**
     * 前台商品咨询列表
     * @param $goodsId
     * @return \Doctrine\ORM\Query
     */
    public function findShopGoodsConsultList($goodsId)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('c', 'u.userAvatar')
            ->from(GoodsConsultation::class, 'c')
            ->leftJoin(User::class, 'u', Join::WITH, 'c.userId = u.userId')
            ->where('c.consultShowStatus = 1')
            ->andWhere('c.goodsId = :goodsId')->setParameter('goodsId', $goodsId)
            ->orderBy('c.consultId', 'DESC');

        return $query->getQuery();
    }
}