<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Goods\Entity\GoodsImage;
use function Doctrine\ORM\QueryBuilder;

class GoodsImageRepository extends EntityRepository
{

    /**
     * 编辑器的商品图片列表
     * @param $goodsId
     * @param $sessionId
     * @param string $imageIdStr
     * @return int|mixed|string
     */
    public function editorGoodsImageList($goodsId, $sessionId, string $imageIdStr = '')
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('i')
            ->from(GoodsImage::class, 'i')
            ->where($query->expr()->orX()
                ->add($query->expr()->eq('i.goodsId', ':goodsId'))
                ->add($query->expr()->andX()->add($query->expr()->eq('i.goodsId', '0'))->add($query->expr()->eq('i.imageCode', ':imageCode')))
            )->setParameter('goodsId', $goodsId)->setParameter('imageCode', $sessionId)
            ->orderBy('i.imageSort', 'ASC');

        if (!empty($imageIdStr)) {
            $imageIdArray = array_filter(explode('|', $imageIdStr));
            if (!empty($imageIdArray)) $query->andWhere($query->expr()->notIn('i.goodsImageId', $imageIdArray));
        }

        return $query->getQuery()->getResult();
    }
}