<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Goods\Entity\Goods;
use Goods\Entity\GoodsInClass;
use Goods\Repository\QuerySearch\GoodsInClassSearch;

class GoodsInClassRepository extends EntityRepository
{
    /**
     * 获取分类商品
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findClassInGoods(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('i', 'g.goodsName', 'g.goodsState', 'g.classId')
            ->from(GoodsInClass::class, 'i')
            ->innerJoin(Goods::class, 'g', Join::WITH, 'g.goodsId=i.goodsId')
            ->orderBy('i.classGoodsRecommend', 'DESC')
            ->orderBy('i.classGoodsSort', 'ASC');

        //检索
        $query = GoodsInClassSearch::querySearchData($search, $query);

        return $query->getQuery();
    }

    /*==============================================下面为前台调用==============================================*/

    /**
     * 前台商品分类推荐商品
     * @param $classId
     * @return int|mixed|string
     */
    public function shopFindClassRecommendGoods($classId)
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('i', 'g.goodsName')
            ->from(GoodsInClass::class, 'i')
            ->innerJoin(Goods::class, 'g', Join::WITH, 'g.goodsId=i.goodsId')
            ->where('i.classId = :classId')->setParameter('classId', $classId)
            ->andWhere('i.classGoodsRecommend = 1')
            ->andWhere('g.goodsState = 1');

        return $query->getQuery()->getResult();
    }
}