<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Goods\Entity\GoodsInSpecGroupTag;
use Goods\Entity\GoodsTag;
use Goods\Entity\GoodsTagGroup;

class GoodsInSpecGroupTagRepository extends EntityRepository
{
    /**
     * 后台添加编辑商品时的规格组获取
     * @param $goodsId
     * @return array
     */
    public function findGoodsSpecGroupTag($goodsId)
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('s', 't.tagGroupName')
            ->from(GoodsInSpecGroupTag::class, 's')
            ->innerJoin(GoodsTagGroup::class, 't', Join::WITH, 's.groupId=t.tagGroupId')
            ->where('s.goodsId = :goodsId')->setParameter('goodsId', $goodsId)
            ->orderBy('t.tagGroupSort', ' ASC');

        $specGroupTag = $query->getQuery()->getResult();
        $specGroupTagArray = [];
        if($specGroupTag) foreach ($specGroupTag as $groupTagValue) {
            $specGroupTagArray[$groupTagValue[0]->getGroupId()] = $groupTagValue[0]->valuesArray();
            $specGroupTagArray[$groupTagValue[0]->getGroupId()]['selectedTagId'] = explode(',', $specGroupTagArray[$groupTagValue[0]->getGroupId()]['selectedTagId']);
            $specGroupTagArray[$groupTagValue[0]->getGroupId()]['tagGroupName'] = $groupTagValue['tagGroupName'];
        }

        return $specGroupTagArray;
    }

    /*==============================================商城前台==============================================*/
    /**
     * 前台商品详情的规格组及规格信息
     * @param $goodsId
     * @return array
     */
    public function findShopGoodsSpecGroupTag($goodsId)
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('s', 't.tagGroupName')
            ->from(GoodsInSpecGroupTag::class, 's')
            ->innerJoin(GoodsTagGroup::class, 't', Join::WITH, 's.groupId=t.tagGroupId')
            ->where('s.goodsId = :goodsId')->setParameter('goodsId', $goodsId)
            ->orderBy('t.tagGroupSort', ' ASC');

        $specGroupTag = $query->getQuery()->getResult();
        $specGroupTagArray = [];
        $specTagIdStr = '';
        if($specGroupTag) foreach ($specGroupTag as $groupTagValue) {
            $specGroupTagArray[$groupTagValue[0]->getGroupId()] = $groupTagValue[0]->valuesArray();
            $specGroupTagArray[$groupTagValue[0]->getGroupId()]['tagGroupName'] = $groupTagValue['tagGroupName'];
            $specTagIdStr .= $specGroupTagArray[$groupTagValue[0]->getGroupId()]['selectedTagId'] . ',';
        }

        $tagIdArray = array_filter(explode(',', rtrim($specTagIdStr, ',')));
        if(!empty($tagIdArray)) {
            $query = $this->getEntityManager()->createQueryBuilder();
            $query->select('t')->from(GoodsTag::class, 't')->where($query->expr()->in('t.tagId', $tagIdArray))->orderBy('t.tagSort', 'ASC');
            $tagResult = $query->getQuery()->getResult();
            if($tagResult) foreach ($tagResult as $tagValue) {
                if(isset($specGroupTagArray[$tagValue->getTagGroupId()])) {
                    $specGroupTagArray[$tagValue->getTagGroupId()]['tagList'][] = ['tagId' => $tagValue->getTagId(), 'tagName' => $tagValue->getTagName()];
                }
            }
        }

        return $specGroupTagArray;
    }
}