<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Goods\Entity\GoodsImage;
use Goods\Entity\GoodsInSpecImage;

class GoodsInSpecImageRepository extends EntityRepository
{
    /**
     * 获取商品规格中某个可设置规格图片的图片列表
     * @param $tagId
     * @param $goodsId
     * @return int|mixed|string
     */
    public function findGoodsSpecImageList($tagId, $goodsId)
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('s', 'i.goodsThumbnailImage', 'i.goodsImage')
            ->from(GoodsInSpecImage::class, 's')
            ->innerJoin(GoodsImage::class, 'i', Join::WITH, 'i.goodsImageId = s.goodsImageId')
            ->where('s.tagId = :tagId')->setParameter('tagId', $tagId)
            ->andWhere('s.goodsId = :goodsId')->setParameter('goodsId', $goodsId)
            ->andWhere('i.imageSlide = 1')
            ->orderBy('i.imageSort', 'ASC');

        return $query->getQuery()->getResult();
    }
}