<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Goods\Entity\Goods;
use Goods\Entity\GoodsInTag;

class GoodsInTagRepository extends EntityRepository
{
    /**
     * 标签商品
     * @param $tagId
     * @return \Doctrine\ORM\Query
     */
    public function findInTagGoods($tagId)
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('t', 'g.goodsName', 'g.goodsState')
            ->from(GoodsInTag::class, 't')
            ->innerJoin(Goods::class, 'g', Join::WITH, 'g.goodsId = t.goodsId')
            ->where('t.tagId = :tagId')->setParameter('tagId', $tagId)
            ->orderBy('t.tagGoodsSort', 'ASC')
            ->addOrderBy('t.goodsId', 'DESC');

        return $query->getQuery();
    }
}