<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Goods\Entity\GoodsInWholesale;

class GoodsInWholesaleRepository extends EntityRepository
{
    /**
     * 获取批发价格信息
     * @param $buyNum
     * @return int|mixed|string
     * @throws \Doctrine\ORM\NoResultException
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findGoodsInWholesale($buyNum)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('w')
            ->from(GoodsInWholesale::class, 'w')
            ->where('w.wholesaleStartNum <= :buyNum')->setParameter('buyNum', $buyNum)
            ->orderBy('w.wholesaleStartNum', 'DESC')
            ->setMaxResults(1);

        return $query->getQuery()->getOneOrNullResult();
    }
}