<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Goods\Entity\GoodsSpecTag;
use Goods\Entity\GoodsSpecTagGoods;

class GoodsSpecTagRepository extends EntityRepository
{
    /**
     * 特定标签列表，用于后台
     * @param array $templateCode
     * @return mixed
     */
    public function findAllSpecTag(array $templateCode)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('s')
            ->addSelect('(SELECT COUNT(g.goodsId) FROM '.GoodsSpecTagGoods::class.' AS g WHERE g.specTagId = s.specTagId) AS goodsNum')
            ->from(GoodsSpecTag::class, 's')
            ->orderBy('s.specTagSort', 'ASC');

        $query->where('s.templateCode = :templateCode')->setParameter('templateCode', $templateCode[0]);
        if(isset($templateCode[1])) $query->orWhere('s.templateCode = :pcTemplateCode')->setParameter('pcTemplateCode', $templateCode[1]);

        return $query->getQuery()->getResult();
    }
}