<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Goods\Entity\GoodsTagGroup;

class GoodsTagGroupRepository extends EntityRepository
{
    /**
     * 通过id数组获取标签组
     * @param array $idArray
     * @return mixed
     */
    public function findTagGroupInId(array $idArray)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('t')
            ->from(GoodsTagGroup::class, 't')
            ->where($query->expr()->in('t.tagGroupId', $idArray))
            ->orderBy('t.tagGroupSort', 'ASC');

        return $query->getQuery()->getResult();
    }
}