<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Goods\Entity\GoodsInTag;
use Goods\Entity\GoodsTag;
use Goods\Entity\GoodsTagGroup;
use Goods\Repository\QuerySearch\GoodsTagSearch;

class GoodsTagRepository extends EntityRepository
{
    /**
     * 获取标签组ID数组对应的标签
     * @param array $idArray
     * @return mixed
     */
    public function findGoodsTagInTagGroupId(array $idArray)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('t')
            ->from(GoodsTag::class, 't')
            ->where($query->expr()->in('t.tagGroupId', $idArray))
            ->orderBy('t.tagSort', 'ASC');

        return $query->getQuery()->getResult();
    }

    /**
     * 获取标签的同时获取商品选中的标签
     * @param $goodsId
     * @return mixed
     */
    public function findGoodsTagAndInGoods($goodsId)
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('t')
            ->addSelect("(SELECT i.inTagId FROM ".GoodsInTag::class." as i WHERE i.tagId=t.tagId AND i.goodsId = $goodsId) as inTagId")
            ->from(GoodsTag::class, 't')
            ->orderBy('t.tagSort', 'ASC');

        return $query->getQuery()->getResult();
    }

    /**
     * 商品标签列表
     * @param array $search
     * @return mixed
     */
    public function findAllGoodsTag(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('t', 'g')
            ->addSelect('(SELECT COUNT(i.inTagId) FROM '.GoodsInTag::class.' AS i WHERE i.tagId=t.tagId) AS goodsNum')
            ->from(GoodsTag::class, 't')
            ->leftJoin('t.oneTagGroup', 'g')
            ->orderBy('t.tagGroupId', 'ASC')
            ->addOrderBy('t.tagSort', 'ASC')
            ->addOrderBy('t.tagId', 'ASC');

        $query = GoodsTagSearch::querySearch($search, $query);

        return $query->getQuery()->getResult();
    }

    /*==============================================下面为前台调用==============================================*/

    /**
     * 购物车中获取规格商品的规格信息
     * @param $tagIdArray
     * @return int|mixed|string
     */
    public function findGoodsTagAndTagGroup($tagIdArray)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('t', 'g.tagGroupName')
            ->from(GoodsTag::class, 't')
            ->innerJoin(GoodsTagGroup::class, 'g', Join::WITH, 'g.tagGroupId=t.tagGroupId')
            ->where($query->expr()->in('t.tagId', $tagIdArray))
            ->orderBy('g.tagGroupSort', 'ASC');

        return $query->getQuery()->getResult();
    }
}