<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class GoodsConsultSearch
{
    /**
     * 后台商品咨询检索
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearch($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['goods_name']) && !empty($search['goods_name']))               $queryBuilder->andWhere($queryBuilder->expr()->like('g.goodsName', "'%".$search['goods_name']."%'"));
        if(isset($search['consult_content']) && !empty($search['consult_content']))     $queryBuilder->andWhere($queryBuilder->expr()->like('c.consultContent', "'%".$search['consult_content']."%'"));
        if(isset($search['consult_user']) && !empty($search['consult_user']))           $queryBuilder->andWhere($queryBuilder->expr()->eq('c.consultUser', ':consultUser'))->setParameter('consultUser', $search['consult_user']);
        if(isset($search['start_time']) && !empty($search['start_time']))               $queryBuilder->andWhere($queryBuilder->expr()->gte('c.consultTime', ':startTime'))->setParameter('startTime', strtotime($search['start_time'].' 00:00:00'));
        if(isset($search['end_time']) && !empty($search['end_time']))                   $queryBuilder->andWhere($queryBuilder->expr()->lte('c.consultTime', ':endTime'))->setParameter('endTime', strtotime($search['end_time'].' 23:59:59'));

        return $queryBuilder;
    }
}