<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class GoodsInClassSearch
{
    /**
     * 对检索信息进行处理
     * @param $search
     * @param QueryBuilder $query
     * @return QueryBuilder
     */
    public static function querySearchData($search, QueryBuilder $query)
    {
        if(isset($search['class_id']) && $search['class_id'] > 0) $query->andWhere($query->expr()->eq('i.classId', $search['class_id']));

        return $query;
    }
}