<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class GoodsSearch
{
    /**
     * 后台对检索信息进行处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearch($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['start_id']) && $search['start_id'] > 0)           $queryBuilder->andWhere($queryBuilder->expr()->gte('g.goodsId', $search['start_id']));
        if(isset($search['end_id']) && $search['end_id'] > 0)               $queryBuilder->andWhere($queryBuilder->expr()->lte('g.goodsId', $search['end_id']));
        if(isset($search['goods_name']) && !empty($search['goods_name']))   $queryBuilder->andWhere($queryBuilder->expr()->like('g.goodsName', "'%".$search['goods_name']."%'"));
        if(isset($search['goods_item']) && !empty($search['goods_item']))   $queryBuilder->andWhere($queryBuilder->expr()->like('g.goodsItem', "'%".$search['goods_item']."%'"));
        if(isset($search['start_price']) && $search['start_price'] > 0)     $queryBuilder->andWhere($queryBuilder->expr()->gte('g.goodsPrice', $search['start_price']));
        if(isset($search['end_price']) && $search['end_price'] > 0)         $queryBuilder->andWhere($queryBuilder->expr()->lte('g.goodsPrice', $search['end_price']));
        if(isset($search['class_id']) && $search['class_id'] > 0)           $queryBuilder->andWhere($queryBuilder->expr()->eq('g.classId', ':classId'))->setParameter('classId', intval($search['class_id']));
        if(isset($search['goods_state']) && !empty($search['goods_state'])) $queryBuilder->andWhere($queryBuilder->expr()->eq('g.goodsState', ':goodsState'))->setParameter('goodsState', $search['goods_state']);
        if(isset($search['goods_type']) && !empty($search['goods_type']))   $queryBuilder->andWhere($queryBuilder->expr()->eq('g.goodsType', ':goodsType'))->setParameter('goodsType', intval($search['goods_type']));

        return $queryBuilder;
    }

    /**
     * 前台对商品列表进行检索处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function shopQuerySearch($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['inClassId']) && $search['inClassId'] > 0)     $queryBuilder->andWhere($queryBuilder->expr()->eq('c.classId', ':classId'))->setParameter('classId', intval($search['inClassId']));
        if(isset($search['brandId']) && $search['brandId'] > 0)         $queryBuilder->andWhere($queryBuilder->expr()->eq('g.brandId', ':brandId'))->setParameter('brandId', intval($search['brandId']));

        if(isset($search['tag']) && !empty($search['tag'])) {
            $queryBuilder->andWhere($queryBuilder->expr()->in('t.tagId', $search['tag']));
        }

        return $queryBuilder;
    }

    /**
     * 前台对品牌商品列表进行检索处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function shopBrandQuerySearch($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['brandId']) && $search['brandId'] > 0)         $queryBuilder->andWhere($queryBuilder->expr()->eq('g.brandId', ':brandId'))->setParameter('brandId', intval($search['brandId']));

        return $queryBuilder;
    }

    /**
     * 前台商品搜索进行检索处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function shopSearchGoods($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['keywords']) && !empty($search['keywords'])) {
            $queryBuilder->andWhere($queryBuilder->expr()->orX()
                ->add($queryBuilder->expr()->like('g.goodsName', "'%".$search['keywords']."%'"))
                ->add($queryBuilder->expr()->like('g.goodsExtendName', "'%".$search['keywords']."%'"))
            );
        }

        return $queryBuilder;
    }
}