<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class GoodsTagSearch
{
    /**
     * 对检索信息进行处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearch($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['tag_name']) && !empty($search['tag_name']))       $queryBuilder->andWhere($queryBuilder->expr()->like('t.tagName', "'%".$search['tag_name']."%'"));
        if(isset($search['tag_group_id']) && $search['tag_group_id'] > 0)   $queryBuilder->andWhere($queryBuilder->expr()->eq('t.tagGroupId', $search['tag_group_id']));

        return $queryBuilder;
    }
}