<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsAttribute;
use Goods\Entity\GoodsAttributeGroup;

class GoodsAttributeManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品属性
     * @param array $data
     * @return GoodsAttribute
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addAttribute(array $data)
    {
        $attributeGroup = $this->entityManager->getRepository(GoodsAttributeGroup::class)->findOneByAttributeGroupId($data['attributeGroupId']);
        $attribute      = new GoodsAttribute();
        $attribute->valuesSet($data);
        $attribute->setOneAttributeGroup($attributeGroup);

        $this->entityManager->persist($attribute);
        $this->entityManager->flush();

        return $attribute;
    }

    /**
     * 编辑商品属性
     * @param array $data
     * @param GoodsAttribute $goodsAttribute
     * @return GoodsAttribute
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editAttribute(array $data, GoodsAttribute $goodsAttribute)
    {
        unset($data['attributeGroupId'], $data['attributeType']);
        $goodsAttribute->valuesSet($data);
        $this->entityManager->flush();

        return $goodsAttribute;
    }

    /**
     * 删除商品属性
     * @param GoodsAttribute $goodsAttribute
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteAttribute(GoodsAttribute $goodsAttribute)
    {
        $this->entityManager->remove($goodsAttribute);
        $this->entityManager->flush();

        return true;
    }

    /**
     * 批量删除商品属性
     * @param $attributeIdArray
     */
    public function deleteMoreAttribute($attributeIdArray)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsAttribute::class, 'a')->where($qb->expr()->in('a.attributeId', $attributeIdArray));
        $qb->getQuery()->execute();
    }

    /**
     * 批量更新属性排序
     * @param array $data
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     * @throws \Doctrine\Persistence\Mapping\MappingException
     */
    public function updateAllAttributeSort(array $data)
    {
        foreach ($data['select_id'] as $value) {
            $attributeInfo = $this->entityManager->getRepository(GoodsAttribute::class)->findOneByAttributeId($value);
            if($attributeInfo) {
                $attributeInfo->setAttributeSort($data['attributeSort'][$value]);
            }
        }
        $this->entityManager->flush();
        $this->entityManager->clear(GoodsAttribute::class);
    }
}