<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsAttribute;
use Goods\Entity\GoodsAttributeValue;
use function Doctrine\ORM\QueryBuilder;

class GoodsAttributeValueManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加属性值
     * @param array $data
     * @param GoodsAttribute $goodsAttribute
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addAttributeValue(array $data, GoodsAttribute $goodsAttribute)
    {
        $valueName = explode("\r\n", $data['valueName']);
        foreach ($valueName as $value) {
            $data['valueName'] = $value;
            $attributeValue = new GoodsAttributeValue();
            $attributeValue->valuesSet($data);
            $attributeValue->setAttributeId($goodsAttribute->getAttributeId());
            $attributeValue->setAttributeGroupId($goodsAttribute->getAttributeGroupId());

            $this->entityManager->persist($attributeValue);
        }

        $this->entityManager->flush();
        $this->entityManager->clear(GoodsAttributeValue::class);

        return true;
    }

    /**
     * 编辑属性值
     * @param array $data
     * @param GoodsAttributeValue $goodsAttributeValue
     * @return GoodsAttributeValue
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editAttributeValue(array $data, GoodsAttributeValue $goodsAttributeValue)
    {
        $goodsAttributeValue->valuesSet($data);
        $this->entityManager->flush();

        return $goodsAttributeValue;
    }

    /**
     * 删除属性值
     * @param GoodsAttributeValue $goodsAttributeValue
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteAttributeValue(GoodsAttributeValue $goodsAttributeValue)
    {
        $this->entityManager->remove($goodsAttributeValue);
        $this->entityManager->flush();

        return true;
    }

    /**
     * 根据属性id删除属性值(数组)
     * @param $attributeIdArray
     * @return bool
     */
    public function deleteMoreAttributeValue($attributeIdArray)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsAttributeValue::class, 'v')->where($qb->expr()->in('v.attributeId', $attributeIdArray));

        $qb->getQuery()->execute();

        return true;
    }

    /**
     * 批量修改属性值
     * @param array $data
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     * @throws \Doctrine\Persistence\Mapping\MappingException
     */
    public function updateAllValue(array $data)
    {
        foreach ($data['select_id'] as $key => $value) {
            $attributeValue = $this->entityManager->getRepository(GoodsAttributeValue::class)->findOneByValueId($value);
            if($attributeValue) {
                if($data['editAllState'] == 'sort') {
                    $attributeValue->setValueSort($data['valueSort'][$value]);
                }
                if($data['editAllState'] == 'del') {
                    $this->entityManager->remove($attributeValue);
                }
            }
        }
        $this->entityManager->flush();
        $this->entityManager->clear(GoodsAttributeValue::class);
    }
}