<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsBrandInClass;

class GoodsBrandInClassManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加品牌对应分类
     * @param array $data
     * @param $brandId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addBrandInClass(array $data, $brandId)
    {
        if(!empty($data)) foreach ($data as $classId) {
            $brandInClass = new GoodsBrandInClass();
            $brandInClass->valuesSet(['classId' => $classId, 'brandId' => $brandId]);

            $this->entityManager->persist($brandInClass);
            $this->entityManager->flush();
            $this->entityManager->clear(GoodsBrandInClass::class);
        }
        return true;
    }

    /**
     * 编辑品牌对应分类
     * @param $data
     * @param $brandId
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     * @throws \Doctrine\Persistence\Mapping\MappingException
     */
    public function editGoodsBrandInClass($data, $brandId)
    {
        $brandInClass = $this->entityManager->getRepository(GoodsBrandInClass::class)->findBy(['brandId' => $brandId]);
        if($brandInClass) {
            if(!empty($data)) {
                foreach ($brandInClass as $classValue) {
                    if(in_array($classValue->getClassId(), $data)) unset($data[array_search($classValue->getClassId(), $data)]);
                    else {
                        $this->entityManager->remove($classValue);
                        $this->entityManager->flush();
                    }
                }
            } else {
                $qb = $this->entityManager->createQueryBuilder();
                $qb->delete(GoodsBrandInClass::class, 'i')->where('i.brandId = :brandId')->setParameter('brandId', $brandId)->getQuery()->execute();
            }
        }

        if(!empty($data)) foreach ($data as $classId) {
            $brandInClass = new GoodsBrandInClass();
            $brandInClass->valuesSet(['classId' => $classId, 'brandId' => $brandId]);

            $this->entityManager->persist($brandInClass);
            $this->entityManager->flush();
            $this->entityManager->clear(GoodsBrandInClass::class);
        }

        return true;
    }

    /**
     * 删除商品品牌对应分类
     * @param $brandId
     */
    public function delGoodsBrandInClass($brandId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsBrandInClass::class, 'i')->where('i.brandId = :brandId')->setParameter('brandId', $brandId)->getQuery()->execute();
    }

    /**
     * 删除分类对应的品牌分类
     * @param $classId
     */
    public function delGoodsBrandInClassId($classId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsBrandInClass::class, 'i')->where('i.classId = :classId')->setParameter('classId', $classId)->getQuery()->execute();
    }
}