<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Admin\Data\Config;
use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsClass;

class GoodsClassManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品分类
     * @param array $data
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsClass(array $data)
    {
        $classPath = '';

        if(!empty($data['classImage']['tmp_name'])) $data['classImage'] = str_replace(Config::PUBLIC_PATH, '', $data['classImage']['tmp_name']);
        else unset($data['classImage']);

        $data['classTagGroup'] = isset($data['classTagGroup']) ? serialize($data['classTagGroup']) : serialize([]);

        if($data['classTopId'] > 0) {
            $topClass = $this->entityManager->getRepository(GoodsClass::class)->findOneByClassId($data['classTopId']);
            if($topClass) $classPath = $topClass->getClassPath();
        }

        $classArray = explode("\r\n", $data['className']);
        foreach ($classArray as $value) {
            $data['className'] = $value;

            $goodsClass = new GoodsClass();
            $goodsClass->valuesSet($data);

            $this->entityManager->persist($goodsClass);
            $this->entityManager->flush();

            $oneClassPath = '';
            $oneClassPath = empty($classPath) ? $goodsClass->getClassId() : $classPath . ',' . $goodsClass->getClassId();
            $goodsClass->setClassPath($oneClassPath);
            $this->entityManager->flush();

            $this->entityManager->clear(GoodsClass::class);
        }

        return true;
    }

    /**
     * 更新商品分类
     * @param array $data
     * @param GoodsClass $goodsClass
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editGoodsClass(array $data, GoodsClass $goodsClass)
    {
        $classPath = '';

        if(!empty($data['classImage']['tmp_name'])) $data['classImage'] = str_replace(Config::PUBLIC_PATH, '', $data['classImage']['tmp_name']);
        else unset($data['classImage']);

        $data['classTagGroup'] = isset($data['classTagGroup']) ? serialize($data['classTagGroup']) : serialize([]);

        if($data['classTopId'] > 0) {
            $topClass = $this->entityManager->getRepository(GoodsClass::class)->findOneByClassId($data['classTopId']);
            if($topClass) $classPath = $topClass->getClassPath();
        }

        //用于子集进行处理
        $topId      = $goodsClass->getClassTopId();
        $likeStr    = $goodsClass->getClassPath() . ',';

        $goodsClass->valuesSet($data);
        $this->entityManager->flush();

        $classPath = empty($classPath) ? $goodsClass->getClassId() : $classPath . ',' . $goodsClass->getClassId();
        $goodsClass->setClassPath($classPath);
        $this->entityManager->flush();

        if($topId != $data['classTopId']) {
            $subClass = $this->entityManager->getRepository(GoodsClass::class)->findClassSub($likeStr);
            if($subClass) {
                foreach ($subClass as $subValue) {
                    $classInfo = $this->entityManager->getRepository(GoodsClass::class)->findOneByClassId($subValue->getClassId());
                    if($classInfo) {
                        $updateStr = str_replace($likeStr, $classPath . ',', $subValue->getClassPath());
                        $classInfo->setClassPath($updateStr);
                        $this->entityManager->flush();
                    }
                }
            }
        }

        return true;
    }

    /**
     * 删除商品分类
     * @param GoodsClass $goodsClass
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteGoodsClass(GoodsClass $goodsClass)
    {
        $this->entityManager->remove($goodsClass);
        $this->entityManager->flush();

        return true;
    }

    /**
     * 批量修改分类排序
     * @param array $data
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function updateAllClassSort(array $data)
    {
        foreach ($data['select_id'] as $value) {
            $classInfo = $this->entityManager->getRepository(GoodsClass::class)->findOneByClassId(intval($value));
            if($classInfo) {
                $classInfo->setClassSort($data['classSort'][$value]);
            }
        }
        $this->entityManager->flush();
        $this->entityManager->clear(GoodsClass::class);
    }
}