<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsCustom;
use Laminas\Filter\HtmlEntities;

class GoodsCustomManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品自定义信息
     * @param array $data
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsCustom(array $data, $goodsId)
    {
        $filter = new HtmlEntities();
        foreach ($data['customTitle'] as $key => $value) {
            if(!empty($value) && !empty($data['customContent'][$key])) {
                $goodsCustom = new GoodsCustom();
                $goodsCustom->valuesSet([
                    'goodsId'       => $goodsId,
                    'customTitle'   => $filter->filter($value),
                    'customContent' => $filter->filter($data['customContent'][$key]),
                    'frontShow'     => isset($data['frontShow'][$key]) ? 1 : 2,
                    'customKey'     => intval($key)
                ]);
                $this->entityManager->persist($goodsCustom);
                $this->entityManager->flush();
                $this->entityManager->clear(GoodsCustom::class);
            }
        }
        return true;
    }

    /**
     * 编辑商品自定义信息
     * @param array $data
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editGoodsCustom(array $data, $goodsId)
    {
        $filter = new HtmlEntities();
        foreach ($data['customTitle'] as $key => $value) {
            $inCustom = $this->entityManager->getRepository(GoodsCustom::class)->findOneBy(['goodsId' => $goodsId, 'customKey' => $key]);
            if($inCustom) {
                if(!empty($value) && !empty($data['customContent'][$key])) {
                    $inCustom->valuesSet([
                        'customTitle'   => $filter->filter($value),
                        'customContent' => $filter->filter($data['customContent'][$key]),
                        'frontShow'     => isset($data['frontShow'][$key]) ? 1 : 2
                    ]);
                } else $this->entityManager->remove($inCustom);
                $this->entityManager->flush();
            } else {
                if(!empty($value) && !empty($data['customContent'][$key])) {
                    $goodsCustom = new GoodsCustom();
                    $goodsCustom->valuesSet([
                        'goodsId'       => $goodsId,
                        'customTitle'   => $filter->filter($value),
                        'customContent' => $filter->filter($data['customContent'][$key]),
                        'frontShow'     => isset($data['frontShow'][$key]) ? 1 : 2,
                        'customKey'     => intval($key)
                    ]);
                    $this->entityManager->persist($goodsCustom);
                    $this->entityManager->flush();
                    $this->entityManager->clear(GoodsCustom::class);
                }
            }
        }
        return true;
    }

    /**
     * 根据商品id删除，自定义信息
     * @param $goodsId
     */
    public function deleteGoodsCustomGoodsId($goodsId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsCustom::class, 'c')->where('c.goodsId = :goodsId')->setParameter('goodsId', $goodsId);

        $qb->getQuery()->execute();
    }
}