<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsDiscount;

class GoodsDiscountManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品优惠信息
     * @param array $data
     * @return GoodsDiscount
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsDiscount(array $data)
    {
        $goodsDiscount = new GoodsDiscount();

        $goodsDiscount->setDiscountStartTime(!empty($data['discountStartTime']) ? strtotime($data['discountStartTime']) : 0);
        $goodsDiscount->setDiscountEndTime(!empty($data['discountEndTime']) ? strtotime($data['discountEndTime']) : 0);
        $goodsDiscount->setDiscountUserGroup(serialize($data['discountUserGroup']));
        unset($data['discountStartTime'], $data['discountEndTime'], $data['discountUserGroup']);

        $goodsDiscount->valuesSet($data);

        $this->entityManager->persist($goodsDiscount);
        $this->entityManager->flush();

        return $goodsDiscount;
    }

    /**
     * 更新商品优惠信息
     * @param array $data
     * @param GoodsDiscount $goodsDiscount
     * @return GoodsDiscount
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editGoodsDiscount(array $data, GoodsDiscount $goodsDiscount)
    {
        $goodsDiscount->setDiscountStartTime(!empty($data['discountStartTime']) ? strtotime($data['discountStartTime']) : 0);
        $goodsDiscount->setDiscountEndTime(!empty($data['discountEndTime']) ? strtotime($data['discountEndTime']) : 0);
        $goodsDiscount->setDiscountUserGroup(serialize($data['discountUserGroup']));
        unset($data['discountStartTime'], $data['discountEndTime'], $data['discountUserGroup']);

        $goodsDiscount->valuesSet($data);

        $this->entityManager->flush();

        return $goodsDiscount;
    }

    /**
     * 删除商品优惠信息
     * @param GoodsDiscount $goodsDiscount
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteGoodsDiscount(GoodsDiscount $goodsDiscount)
    {
        $this->entityManager->remove($goodsDiscount);
        $this->entityManager->flush();

        return true;
    }

    /**
     * 根据商品id删除优惠信息
     * @param $goodsId
     */
    public function deleteGoodsDiscountGoodsId($goodsId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsDiscount::class, 'd')->where('d.goodsId = :goodsId')->setParameter('goodsId', $goodsId);

        $qb->getQuery()->execute();
    }
}