<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsGroupPrice;

class GoodsGroupPriceManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品会员组价格
     * @param array $userGroupPriceArray
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsGroupPrice(array $userGroupPriceArray, $goodsId)
    {
        if(!empty($userGroupPriceArray)) foreach ($userGroupPriceArray as $userGroupId => $groupPrice) {
            $userGroupPrice = new GoodsGroupPrice();
            $userGroupPrice->setUserGroupPrice($groupPrice);
            $userGroupPrice->setUserGroupId($userGroupId);
            $userGroupPrice->setGoodsId($goodsId);

            $this->entityManager->persist($userGroupPrice);
            $this->entityManager->flush();
        }
        return true;
    }

    /**
     * 编辑商品会员组价格
     * @param array $userGroupPriceArray
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     * @throws \Doctrine\Persistence\Mapping\MappingException
     */
    public function editGoodsGroupPrice(array $userGroupPriceArray, $goodsId)
    {
        $groupPriceList = $this->entityManager->getRepository(GoodsGroupPrice::class)->findBy(['goodsId' => $goodsId]);
        if($groupPriceList) foreach ($groupPriceList as $groupPriceValue) {
            if(isset($userGroupPriceArray[$groupPriceValue->getUserGroupId()])) {
                if($userGroupPriceArray[$groupPriceValue->getUserGroupId()] != $groupPriceValue->getUserGroupPrice()) {
                    $groupPriceValue->setUserGroupPrice($userGroupPriceArray[$groupPriceValue->getUserGroupId()]);
                    $this->entityManager->flush();
                    $this->entityManager->clear(GoodsGroupPrice::class);
                }
                unset($userGroupPriceArray[$groupPriceValue->getUserGroupId()]);
            } else {
                $this->entityManager->remove($groupPriceValue);
                $this->entityManager->flush();
            }
        }

        if(!empty($userGroupPriceArray))  foreach ($userGroupPriceArray as $userGroupId => $groupPrice) {
            $userGroupPrice = new GoodsGroupPrice();
            $userGroupPrice->setUserGroupPrice($groupPrice);
            $userGroupPrice->setUserGroupId($userGroupId);
            $userGroupPrice->setGoodsId($goodsId);

            $this->entityManager->persist($userGroupPrice);
            $this->entityManager->flush();
            $this->entityManager->clear(GoodsGroupPrice::class);
        }

        return true;
    }

    /**
     * 删除商品会员组价格
     * @param $goodsId
     */
    public function deleteGoodsGroupPrice($goodsId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsGroupPrice::class, 'p')->where('p.goodsId = :goodsId')->setParameter('goodsId', $goodsId);
        $qb->getQuery()->execute();
    }
}