<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Admin\Data\Config;
use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsImage;

class GoodsImageManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品图片
     * @param array $data
     * @return GoodsImage
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsImage(array $data)
    {
        if(!empty($data['goodsImage']['tmp_name'])) {
            $data['goodsThumbnailImage'] = str_replace(Config::PUBLIC_PATH, '', $data['goodsImage']['thumbImage']);
            $data['goodsImage'] = str_replace(Config::PUBLIC_PATH, '', $data['goodsImage']['tmp_name']);
        } else unset($data['goodsImage']);
        $goodsImage = new GoodsImage();
        $goodsImage->valuesSet($data);

        $this->entityManager->persist($goodsImage);
        $this->entityManager->flush();

        return $goodsImage;
    }

    /**
     * 更新商品图片
     * @param array $data
     * @param GoodsImage $goodsImage
     * @return GoodsImage
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editGoodsImage(array $data, GoodsImage $goodsImage)
    {
        $goodsImage->valuesSet($data);
        $this->entityManager->flush();

        return $goodsImage;
    }

    /**
     * 批量修改当前用户上传的没有绑定商品id的图片
     * @param $goodsId
     * @param $sessionId
     */
    public function editMoreGoodsImageGoodsId($goodsId, $sessionId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->update(GoodsImage::class, 'i')->set('i.goodsId', $goodsId)->set('i.imageCode', ':codeValue')->setParameter('codeValue', '')
            ->where('i.imageCode = :imageCode')->setParameter('imageCode', $sessionId)
            ->andWhere('i.goodsId = :id')->setParameter('id', '0');

        $qb->getQuery()->execute();
    }

    /**
     * 更新商品的图片 排序 切换
     * @param $goodsImageIdArray
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function updateMoreGoodsImage($goodsImageIdArray)
    {
        if (is_array($goodsImageIdArray) && !empty($goodsImageIdArray)) {
            foreach ($goodsImageIdArray as $goodsImageId) {
                $goodsImageInfo = $this->entityManager->getRepository(GoodsImage::class)->findOneBy(['goodsImageId' => $goodsImageId]);
                if ($goodsImageInfo) $goodsImageInfo->valuesSet([
                    'imageSlide'    => isset($_POST['imageSlide'.$goodsImageId]) ? (int) $_POST['imageSlide'.$goodsImageId] : '0',
                    'imageSort'     => (int) $_POST['imageSort'.$goodsImageId]
                ]);
            }
            $this->entityManager->flush();
        }
    }

    /**
     * 删除商品图片
     * @param GoodsImage $goodsImage
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteGoodsImage(GoodsImage $goodsImage)
    {
        $this->entityManager->remove($goodsImage);
        $this->entityManager->flush();

        return true;
    }

    /**
     * 删除某一商品的图片信息，返回图片数组供删除使用
     * @param $goodsId
     * @return array
     */
    public function deleteGoodsImageGoodsId($goodsId)
    {
        $goodsImageArray= [];
        $goodsImageList = $this->entityManager->getRepository(GoodsImage::class)->findBy(['goodsId' => $goodsId]);
        if($goodsImageList) foreach ($goodsImageList as $imageValue) {
            $goodsImageArray[] = $imageValue->getGoodsThumbnailImage();
            $goodsImageArray[] = $imageValue->getGoodsImage();
        }

        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsImage::class, 'i')->where('i.goodsId = :goodsId')->setParameter('goodsId', $goodsId);
        $qb->getQuery()->execute();

        return $goodsImageArray;
    }
}