<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsAttribute;
use Goods\Entity\GoodsInAttribute;
use Laminas\Filter\HtmlEntities;
use function Doctrine\ORM\QueryBuilder;

class GoodsInAttributeManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品对应的属性值
     * @param array $data
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsInAttribute(array $data, $goodsId)
    {
        $filter = new HtmlEntities();
        if($data['attributeGroupId'] > 0) {
            $attributeList = $this->entityManager->getRepository(GoodsAttribute::class)->findBy(['attributeGroupId' => $data['attributeGroupId']], ['attributeSort' => 'ASC']);
            if($attributeList) foreach ($attributeList as $attribute) {
                if(!empty($data['attributeValue'][$attribute->getAttributeId()])) {
                    $attributeBody = $attribute->getAttributeType() == 'checkbox' ? implode(',', $filter->filter($data['attributeValue'][$attribute->getAttributeId()])) : $filter->filter($data['attributeValue'][$attribute->getAttributeId()]);
                    $goodsInAttribute = new GoodsInAttribute();
                    $goodsInAttribute->valuesSet(['goodsId' => $goodsId, 'attributeId' => $attribute->getAttributeId(), 'attributeBody' => $attributeBody]);

                    $this->entityManager->persist($goodsInAttribute);
                    $this->entityManager->flush();
                    $this->entityManager->clear(GoodsInAttribute::class);
                }
            }
        }
        return true;
    }

    /**
     * 编辑商品对应的属性值
     * @param array $data
     * @param $attributeGroupId
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editGoodsInAttribute(array $data, $attributeGroupId, $goodsId)
    {
        $filter = new HtmlEntities();
        if($data['attributeGroupId'] > 0) {
            $attributeList = $this->entityManager->getRepository(GoodsAttribute::class)->findBy(['attributeGroupId' => $data['attributeGroupId']], ['attributeSort' => 'ASC']);
            if($data['attributeGroupId'] != $attributeGroupId) {
                if($attributeGroupId > 0) {
                    $qb = $this->entityManager->createQueryBuilder();
                    $qb->delete(GoodsInAttribute::class, 'a')->where('a.goodsId = :goodsId')->setParameter('goodsId', $goodsId)->getQuery()->execute();
                }

                if($attributeList) foreach ($attributeList as $attribute) {
                    if(!empty($data['attributeValue'][$attribute->getAttributeId()])) {
                        $attributeBody = $attribute->getAttributeType() == 'checkbox' ? implode(',', $filter->filter($data['attributeValue'][$attribute->getAttributeId()])) : $filter->filter($data['attributeValue'][$attribute->getAttributeId()]);
                        $goodsInAttribute = new GoodsInAttribute();
                        $goodsInAttribute->valuesSet(['goodsId' => $goodsId, 'attributeId' => $attribute->getAttributeId(), 'attributeBody' => $attributeBody]);

                        $this->entityManager->persist($goodsInAttribute);
                        $this->entityManager->flush();
                        $this->entityManager->clear(GoodsInAttribute::class);
                    }
                }
            } else {
                $attributeArray= [];
                if($attributeList) foreach ($attributeList as $attribute) {
                    $attributeArray[$attribute->getAttributeId()] = $attribute->getAttributeType();
                }
                if(empty($attributeArray)) {
                    $qb = $this->entityManager->createQueryBuilder();
                    $qb->delete(GoodsInAttribute::class, 'a')->where('a.goodsId = :goodsId')->setParameter('goodsId', $goodsId)->getQuery()->execute();

                    return true;
                }

                $goodsInAttribute = $this->entityManager->getRepository(GoodsInAttribute::class)->findBy(['goodsId' => $goodsId]);
                if($goodsInAttribute) foreach ($goodsInAttribute as $inAttributeValue) {
                    if(isset($attributeArray[$inAttributeValue->getAttributeId()])) {
                        $attributeBody = $attributeArray[$inAttributeValue->getAttributeId()] == 'checkbox' ? implode(',', $filter->filter($data['attributeValue'][$inAttributeValue->getAttributeId()])) : $filter->filter($data['attributeValue'][$inAttributeValue->getAttributeId()]);
                        $inAttributeValue->valuesSet(['attributeBody' => $attributeBody]);
                        unset($attributeArray[$inAttributeValue->getAttributeId()]);
                    } else $this->entityManager->remove($inAttributeValue);
                    $this->entityManager->flush();
                }

                if(!empty($attributeArray)) foreach ($attributeArray as $aAttributeId => $aAttributeType) {
                    if(!empty($data['attributeValue'][$aAttributeId])) {
                        $attributeBody = $aAttributeType == 'checkbox' ? implode(',', $filter->filter($data['attributeValue'][$aAttributeId])) : $filter->filter($data['attributeValue'][$aAttributeId]);
                        $goodsInAttribute = new GoodsInAttribute();
                        $goodsInAttribute->valuesSet(['goodsId' => $goodsId, 'attributeId' => $aAttributeId, 'attributeBody' => $attributeBody]);

                        $this->entityManager->persist($goodsInAttribute);
                        $this->entityManager->flush();
                        $this->entityManager->clear(GoodsInAttribute::class);
                    }
                }
            }
        } else {
            $qb = $this->entityManager->createQueryBuilder();
            $qb->delete(GoodsInAttribute::class, 'a')->where('a.goodsId = :goodsId')->setParameter('goodsId', $goodsId)->getQuery()->execute();
        }

        return true;
    }

    /**
     * 根据商品id删除商品对应的属性
     * @param $goodsId
     */
    public function deleteGoodsInAttributeGoodsId($goodsId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsInAttribute::class, 'a')->where('a.goodsId = :goodsId')->setParameter('goodsId', $goodsId);
        $qb->getQuery()->execute();
    }

    /**
     * 根据商品属性id删除对应属性（数组）
     * @param $attributeIdArray
     */
    public function deleteGoodsInAttributeId($attributeIdArray)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsInAttribute::class, 'a')->where($qb->expr()->in('a.attributeId', $attributeIdArray));
        $qb->getQuery()->execute();
    }
}