<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsInClass;

class GoodsInClassManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品分类
     * @param array $data
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsInClass(array $data, $goodsId)
    {
        foreach ($data as $classId) {
            $inClass = new GoodsInClass();
            $inClass->valuesSet(['classId' => $classId, 'goodsId' => $goodsId]);

            $this->entityManager->persist($inClass);
            $this->entityManager->flush();
            $this->entityManager->clear(GoodsInClass::class);
        }
        return true;
    }

    /**
     * 编辑更新商品分类
     * @param array $data
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editGoodsInClass(array $data, $goodsId)
    {
        $inClassList = $this->entityManager->getRepository(GoodsInClass::class)->findBy(['goodsId' => $goodsId]);
        if($inClassList) foreach ($inClassList as $classValue) {
            if(in_array($classValue->getClassId(), $data)) unset($data[array_search($classValue->getClassId(), $data)]);
            else {
                $this->entityManager->remove($classValue);
                $this->entityManager->flush();
            }
        }

        if(!empty($data)) foreach ($data as $classId) {
            $inClass = new GoodsInClass();
            $inClass->valuesSet(['classId' => $classId, 'goodsId' => $goodsId]);

            $this->entityManager->persist($inClass);
            $this->entityManager->flush();
            $this->entityManager->clear(GoodsInClass::class);
        }

        return true;
    }

    /**
     * 删除某一个分类中的所有商品
     * @param $classId
     */
    public function delClassGoods($classId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsInClass::class, 'i')->where('i.classId = :classId')->setParameter('classId', $classId);

        $qb->getQuery()->execute();
    }

    /**
     * 删除某一个商品中的所有分类
     * @param $goodsId
     */
    public function delGoodsInClassGoodsId($goodsId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsInClass::class, 'i')->where('i.goodsId = :goodsId')->setParameter('goodsId', $goodsId);

        $qb->getQuery()->execute();
    }

    /**
     * 编辑更新单个分类商品
     * @param array $data
     * @param GoodsInClass $goodsInClass
     * @return GoodsInClass
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function updateInClassGoods(array $data, GoodsInClass $goodsInClass)
    {
        $goodsInClass->valuesSet($data);
        $this->entityManager->flush();

        return $goodsInClass;
    }

    /**
     * 删除商品分类中的某一个商品
     * @param GoodsInClass $goodsInClass
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function delInClassGoods(GoodsInClass $goodsInClass)
    {
        $this->entityManager->remove($goodsInClass);
        $this->entityManager->flush();

        return true;
    }
}