<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsInSpecGoods;
use Goods\Entity\GoodsInSpecGoodsGroupPrice;

class GoodsInSpecGoodsGroupPriceManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加规格商品客户组价格
     * @param array $data
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addGoodsInSpecGoodsGroupPrice(array $data, $goodsId)
    {
        $inSpecGoodsList = $this->entityManager->getRepository(GoodsInSpecGoods::class)->findBy(['goodsId' => $goodsId]);
        if($inSpecGoodsList) foreach ($inSpecGoodsList as $specGoods) {
            if(!empty($data['specGoodsUserGroupPrice'][$specGoods->getSpecTagId()])) foreach ($data['specGoodsUserGroupPrice'][$specGoods->getSpecTagId()] as $userGroupId => $specGoodsPrice) {
                $inSpecGoodsGroupPrice = new GoodsInSpecGoodsGroupPrice();
                $inSpecGoodsGroupPrice->setUserGroupPrice($specGoodsPrice);
                $inSpecGoodsGroupPrice->setUserGroupId($userGroupId);
                $inSpecGoodsGroupPrice->setInSpecGoodsId($specGoods->getInSpecGoodsId());
                $inSpecGoodsGroupPrice->setGoodsId($goodsId);

                $this->entityManager->persist($inSpecGoodsGroupPrice);
                $this->entityManager->flush();
            }
        }
        return true;
    }

    /**
     * 修改规格商品客户组价格
     * @param array $data
     * @param $goodsId
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editGoodsInSpecGoodsGroupPrice(array $data, $goodsId)
    {
        $inSpecGoodsList = $this->entityManager->getRepository(GoodsInSpecGoods::class)->findBy(['goodsId' => $goodsId]);
        if($inSpecGoodsList) foreach ($inSpecGoodsList as $specGoods) {
            $inSpecGroupPriceList = $this->entityManager->getRepository(GoodsInSpecGoodsGroupPrice::class)->findBy(['goodsId' => $goodsId, 'inSpecGoodsId' => $specGoods->getInSpecGoodsId()]);
            if($inSpecGroupPriceList) foreach ($inSpecGroupPriceList as $groupPriceValue) {
                if(isset($data['specGoodsUserGroupPrice'][$specGoods->getSpecTagId()][$groupPriceValue->getUserGroupId()])) {
                    if($data['specGoodsUserGroupPrice'][$specGoods->getSpecTagId()][$groupPriceValue->getUserGroupId()] != $groupPriceValue->getUserGroupPrice()) {
                        $groupPriceValue->setUserGroupPrice($data['specGoodsUserGroupPrice'][$specGoods->getSpecTagId()][$groupPriceValue->getUserGroupId()]);
                        $this->entityManager->flush();
                        $this->entityManager->clear(GoodsInSpecGoodsGroupPrice::class);
                    }
                    unset($data['specGoodsUserGroupPrice'][$specGoods->getSpecTagId()][$groupPriceValue->getUserGroupId()]);
                } else {
                    $this->entityManager->remove($groupPriceValue);
                    $this->entityManager->flush();
                }
            }

            if(!empty($data['specGoodsUserGroupPrice'][$specGoods->getSpecTagId()])) foreach ($data['specGoodsUserGroupPrice'][$specGoods->getSpecTagId()] as $userGroupId => $specGoodsPrice) {
                $inSpecGoodsGroupPrice = new GoodsInSpecGoodsGroupPrice();
                $inSpecGoodsGroupPrice->setUserGroupPrice($specGoodsPrice);
                $inSpecGoodsGroupPrice->setUserGroupId($userGroupId);
                $inSpecGoodsGroupPrice->setInSpecGoodsId($specGoods->getInSpecGoodsId());
                $inSpecGoodsGroupPrice->setGoodsId($goodsId);

                $this->entityManager->persist($inSpecGoodsGroupPrice);
                $this->entityManager->flush();
                $this->entityManager->clear(GoodsInSpecGoodsGroupPrice::class);
            }
        }

        return true;
    }

    /**
     * 删除规格商品会员组价格
     * @param $goodsId
     */
    public function deleteGoodsInSpecGoodsGroupPrice($goodsId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsInSpecGoodsGroupPrice::class, 'p')->where('p.goodsId = :goodsId')->setParameter('goodsId', $goodsId);
        $qb->getQuery()->execute();
    }
}