<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Goods\Service;

use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsInSpecGoods;
use Goods\Entity\GoodsInSpecGoodsGroupPrice;
use Goods\Entity\GoodsInSpecGroupTag;
use Goods\Entity\GoodsInSpecImage;

class GoodsInSpecGroupTagManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加商品规格组及组内值
     * @param array $data
     * @param $goodsId
     * @return array
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addInSpecGroupTag(array $data, $goodsId)
    {
        $imageGroupId = 0;
        if(isset($data['specImage']) && !empty($data['specImage'])) $imageGroupId = $data['specImage'][0];

        if(isset($data['goodsSpecGroupId']) && !empty($data['goodsSpecGroupId'])) {
            foreach ($data['goodsSpecGroupId'] as $specGroupId) {
                if(isset($data['goodsSpecGroup'.$specGroupId]) && !empty($data['goodsSpecGroup'.$specGroupId])) {
                    $specGroupTag = new GoodsInSpecGroupTag();
                    $specGroupTag->valuesSet([
                        'goodsId' => $goodsId,
                        'groupId' => $specGroupId,
                        'selectedTagId' => implode(',', $data['goodsSpecGroup'.$specGroupId]),
                        'groupImage' => ($imageGroupId == $specGroupId ? 1 : 0)
                    ]);

                    $this->entityManager->persist($specGroupTag);
                    $this->entityManager->flush();
                    $this->entityManager->clear(GoodsInSpecGroupTag::class);
                }
            }
        }
        return ['imageGroupId' => $imageGroupId];
    }

    /**
     * 编辑商品规格组及组内值
     * @param array $data
     * @param $goodsId
     * @return array
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editInSpecGroupTag(array $data, $goodsId)
    {
        $imageGroupId = 0;
        if(isset($data['specImage']) && !empty($data['specImage'])) $imageGroupId = $data['specImage'][0];

        if(isset($data['goodsSpecGroupId']) && !empty($data['goodsSpecGroupId'])) {
            $specGroupTag = $this->entityManager->getRepository(GoodsInSpecGroupTag::class)->findBy(['goodsId' => $goodsId]);
            if($specGroupTag) foreach ($specGroupTag as $gtValue) {
                if(!in_array($gtValue->getGroupId(), $data['goodsSpecGroupId'])) {
                    $this->entityManager->remove($gtValue);
                } else {
                    $gtValue->valuesSet(['selectedTagId' => (isset($data['goodsSpecGroup'.$gtValue->getGroupId()]) ? implode(',', $data['goodsSpecGroup'.$gtValue->getGroupId()]) : null), 'groupImage' => $imageGroupId == $gtValue->getGroupId() ? 1 : 0]);
                    unset($data['goodsSpecGroupId'][array_search($gtValue->getGroupId(), $data['goodsSpecGroupId'])]);
                }
                $this->entityManager->flush();
            }

            if(!empty($data['goodsSpecGroupId'])) foreach ($data['goodsSpecGroupId'] as $specGroupId) {
                if(isset($data['goodsSpecGroup'.$specGroupId]) && !empty($data['goodsSpecGroup'.$specGroupId])) {
                    $specGroupTag = new GoodsInSpecGroupTag();
                    $specGroupTag->valuesSet([
                        'goodsId' => $goodsId,
                        'groupId' => $specGroupId,
                        'selectedTagId' => implode(',', $data['goodsSpecGroup'.$specGroupId]),
                        'groupImage' => ($imageGroupId == $specGroupId ? 1 : 0)
                    ]);

                    $this->entityManager->persist($specGroupTag);
                    $this->entityManager->flush();
                    $this->entityManager->clear(GoodsInSpecGroupTag::class);
                }
            }
        } else {
            $qb = $this->entityManager->createQueryBuilder();
            $qb->delete(GoodsInSpecGroupTag::class, 'i')->where('i.goodsId = :goodsId')->setParameter('goodsId', $goodsId)->getQuery()->execute();
            $qb->delete(GoodsInSpecGoods::class, 'i')->where('i.goodsId = :goodsId')->setParameter('goodsId', $goodsId)->getQuery()->execute();
            $qb->delete(GoodsInSpecImage::class, 'si')->where('si.goodsId = :goodsId')->setParameter('goodsId', $goodsId)->getQuery()->execute();
            $qb->delete(GoodsInSpecGoodsGroupPrice::class, 'gi')->where('gi.goodsId = :goodsId')->setParameter('goodsId', $goodsId)->getQuery()->execute();
        }

        return ['imageGroupId' => $imageGroupId];
    }

    /**
     * 根据商品id删除对应规格组
     * @param $goodsId
     */
    public function deleteInSpecGroupTagGoodsId($goodsId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(GoodsInSpecGroupTag::class, 's')->where('s.goodsId = :goodsId')->setParameter('goodsId', $goodsId);
        $qb->getQuery()->execute();
    }
}